package gov.va.med.mhv.health.validator;

import gov.va.med.mhv.health.dto.HealthHistoryRecordDTO;
import gov.va.med.mhv.health.dto.ResponseUtil;
import java.util.HashSet;
import java.util.Set;

import org.springframework.stereotype.Component;

@Component
public class FamilyValidator extends Validator{
	
	private static final String RELATIONSHIP="family";
	private static final String FIRSTNAME="firstName";

	public void familyValidations(ResponseUtil response, HealthHistoryRecordDTO healthHistoryRecordDTO) {
		validateStep1(response, healthHistoryRecordDTO);
		validateIssues(response, healthHistoryRecordDTO);

	}

	private void validateStep1(ResponseUtil response, HealthHistoryRecordDTO healthHistoryRecordDTO) {
		
		if(healthHistoryRecordDTO.getRelationship().trim().isEmpty() || healthHistoryRecordDTO.getRelationship()==null) {
			response.getValidationErrors().put("family", "Relationship is a required field.");
		}
		
		if(healthHistoryRecordDTO.getFirstName().trim().isEmpty() || healthHistoryRecordDTO.getFirstName()==null) {
			response.getValidationErrors().put("firstName", "First Name is a required field.");
		}

	
	}

	public void validateIssues(ResponseUtil response, HealthHistoryRecordDTO healthHistoryRecordDTO) {
		Set<String> healthIssuesSet = new HashSet<String>();
		int totalIssues=0;

		// Airway/Breathing Conditions

		if (healthHistoryRecordDTO.getAwAsthma()) {
			healthIssuesSet.add("Asthma");
		}
		if (healthHistoryRecordDTO.getAwBronchitis()) {
			healthIssuesSet.add("Bronchitis");
		}
		if (healthHistoryRecordDTO.getAwCOPD()) {
			healthIssuesSet.add("COPD (Chronic Obstructive Pulmonary Disease)");
		}
		if (healthHistoryRecordDTO.getAwEmphysema()) {
			healthIssuesSet.add("Emphysema");
		}
		if (healthHistoryRecordDTO.getAwPneumonia()) {
			healthIssuesSet.add("Pneumonia");
		}
		if (healthHistoryRecordDTO.getAwSoB()) {
			healthIssuesSet.add("Shortness of Breath");
		}
		if (healthHistoryRecordDTO.getAwTuberculosis()) {
			healthIssuesSet.add("Tuberculosis");
		}
		if (healthHistoryRecordDTO.getAwOther()) {
			healthIssuesSet.add("Other");
		}

		// Allergy/Immune System Conditions

		if(healthHistoryRecordDTO.getAlAllergies()) {
			healthIssuesSet.add("Allergies");
		}
		if(healthHistoryRecordDTO.getAlLupus()) {
			healthIssuesSet.add("Lupus");
		}
		if(healthHistoryRecordDTO.getAlOther()) {
			healthIssuesSet.add("Other");
		}

		// Alcohol Conditions
		if (healthHistoryRecordDTO.getAlcSocial()) {
			healthIssuesSet.add("Social");
		}
		if (healthHistoryRecordDTO.getAlcOneDrink()) {
			healthIssuesSet.add("1 beer/wine a day");
		}
		if (healthHistoryRecordDTO.getAlcSixDrinks()) {
			healthIssuesSet.add(">6 beers/wines a day");
		}
		if (healthHistoryRecordDTO.getAlcTwoShots()) {
			healthIssuesSet.add(">2 shots a day");
		}

		// Blood Disorders

		if (healthHistoryRecordDTO.getBlAnemia()) {
			healthIssuesSet.add("Anemia");
		}
		if (healthHistoryRecordDTO.getBlBruising()) {
			healthIssuesSet.add("Bruising");
		}
		if (healthHistoryRecordDTO.getBlClotting()) {
			healthIssuesSet.add("Clotting");
		}
		if (healthHistoryRecordDTO.getBlLeukemia()) {
			healthIssuesSet.add("Leukemia");
		}
		if (healthHistoryRecordDTO.getBlSickleCell()) {
			healthIssuesSet.add("Sickle Cell Anemia");
		}
		if (healthHistoryRecordDTO.getBlOther()) {
			healthIssuesSet.add("Other");
		}

		// Body Aches

		if (healthHistoryRecordDTO.getBaArthritis()) {
			healthIssuesSet.add("Arthritis");
		}
		if (healthHistoryRecordDTO.getBaFibromyalgia()) {
			healthIssuesSet.add("Fibromyalgia");
		}
		if (healthHistoryRecordDTO.getBaJointPain()) {
			healthIssuesSet.add("Joint Pain");
		}
		if (healthHistoryRecordDTO.getBaLymeDisease()) {
			healthIssuesSet.add("Lyme Disease");
		}
		if (healthHistoryRecordDTO.getBaOther()) {
			healthIssuesSet.add("Other");
		}

		// Cancers

		if (healthHistoryRecordDTO.getCaBreast()) {
			healthIssuesSet.add("Breast");
		}
		if (healthHistoryRecordDTO.getCaBowel()) {
			healthIssuesSet.add("Bowel");
		}
		if (healthHistoryRecordDTO.getCaColon()) {
			healthIssuesSet.add("Colon");
		}
		if (healthHistoryRecordDTO.getCaLung()) {
			healthIssuesSet.add("Lung");
		}
		if (healthHistoryRecordDTO.getCaOvarian()) {
			healthIssuesSet.add("Ovarian");
		}
		if (healthHistoryRecordDTO.getCaSkin()) {
			healthIssuesSet.add("Skin");
		}
		if (healthHistoryRecordDTO.getCaStomach()) {
			healthIssuesSet.add("Stomach");
		}
		if (healthHistoryRecordDTO.getCaProstate()) {
			healthIssuesSet.add("Prostate");
		}
		if (healthHistoryRecordDTO.getCaOther()) {
			healthIssuesSet.add("Other");
		}

		// Childhood Diseases

		if (healthHistoryRecordDTO.getChChickenPox()) {
			healthIssuesSet.add("Chicken Pox");
		}
		if (healthHistoryRecordDTO.getChDiphtheria()) {
			healthIssuesSet.add("Diphtheria");
		}
		if (healthHistoryRecordDTO.getChMeasles()) {
			healthIssuesSet.add("Measles");
		}
		if (healthHistoryRecordDTO.getChMumps()) {
			healthIssuesSet.add("Mumps");
		}
		if (healthHistoryRecordDTO.getChWhoopingCough()) {
			healthIssuesSet.add("Whooping Cough");
		}
		if (healthHistoryRecordDTO.getChOther()) {
			healthIssuesSet.add("Other");
		}

		// Diabetes
		if (healthHistoryRecordDTO.getDbType1()) {
			healthIssuesSet.add("Type 1");
		}
		if (healthHistoryRecordDTO.getDbType2()) {
			healthIssuesSet.add("Type 2");
		}
		if (healthHistoryRecordDTO.getDbType3()) {
			healthIssuesSet.add("Type 3");
		}

		// Gallbladder
		if (healthHistoryRecordDTO.getGbDisease()) {
			healthIssuesSet.add("Gallbladder Disease");
		}
		if (healthHistoryRecordDTO.getGbStones()) {
			healthIssuesSet.add("Gallstones");
		}
		if (healthHistoryRecordDTO.getGbOther()) {
			healthIssuesSet.add("Other");
		}

		// Head, Eyes, etc.
		
		if(healthHistoryRecordDTO.getHntCataracts()) {
			healthIssuesSet.add("Cataracts");
		}
		if(healthHistoryRecordDTO.getHntDizziness()) {
			healthIssuesSet.add("Dizziness");
		}
		if(healthHistoryRecordDTO.getHntDyslexia()) {
			healthIssuesSet.add("Dyslexia");
		}
		if(healthHistoryRecordDTO.getHntGlaucoma()) {
			healthIssuesSet.add("Glaucoma");		}
		if(healthHistoryRecordDTO.getHntHearingLoss()) {
			healthIssuesSet.add("Hearing Loss");			
		}
		if(healthHistoryRecordDTO.getHntMigraineHeadaches()){
			healthIssuesSet.add("Migraine Headaches");		
		}
		if(healthHistoryRecordDTO.getHntRetinitisPigmentosa()) {
			healthIssuesSet.add("Retinitis Pigmentosa");		}	
		if(healthHistoryRecordDTO.getHntOther()) {
			healthIssuesSet.add("Other");		
		}

		// Heart/Cardiovascular

		if (healthHistoryRecordDTO.getHeAngina()) {
			healthIssuesSet.add("Angina (Pain)");
		}
		if (healthHistoryRecordDTO.getHeCongestiveFailure()) {
			healthIssuesSet.add("Congestive Failure");
		}
		if (healthHistoryRecordDTO.getHeAttack()) {
			healthIssuesSet.add("Heart Attack");
		}
		if (healthHistoryRecordDTO.getHeMurmur()) {
			healthIssuesSet.add("Heart Murmur");
		}
		if (healthHistoryRecordDTO.getHeHighCholesterol()) {
			healthIssuesSet.add("High Blood Cholesterol");
		}
		if (healthHistoryRecordDTO.getHeHighPressure()) {
			healthIssuesSet.add("High Blood Pressure (Hypertension)	");
		}
		if (healthHistoryRecordDTO.getHeMitralValveProlapse()) {
			healthIssuesSet.add("Mitral Valve Prolapse");
		}
		if (healthHistoryRecordDTO.getHeRhythmAbnormality()) {
			healthIssuesSet.add("Rhythm Abnormality (too fast, too slow, palpitations)");
		}
		if (healthHistoryRecordDTO.getHeStroke()) {
			healthIssuesSet.add("Stroke");
		}
		if (healthHistoryRecordDTO.getHeOther()) {
			healthIssuesSet.add("Other");
		}

		// Kidney

		if (healthHistoryRecordDTO.getKiInfections()) {
			healthIssuesSet.add("Infections");
		}
		if (healthHistoryRecordDTO.getKiStones()) {
			healthIssuesSet.add("Kidney Stones");
		}
		if (healthHistoryRecordDTO.getKiRenalFailure()) {
			healthIssuesSet.add("Renal Failure");
		}
		if (healthHistoryRecordDTO.getKiOther()) {
			healthIssuesSet.add("Other");
		}

		// Liver

		if (healthHistoryRecordDTO.getLiHepatitisA()) {
			healthIssuesSet.add("Hepatitis A");
		}
		if (healthHistoryRecordDTO.getLiHepatitisB()) {
			healthIssuesSet.add("Hepatitis B");
		}
		if (healthHistoryRecordDTO.getLiHepatitisC()) {
			healthIssuesSet.add("Hepatitis C");
		}
		if (healthHistoryRecordDTO.getLiCirrhosis()) {
			healthIssuesSet.add("Cirrhosis");
		}
		if (healthHistoryRecordDTO.getLiOther()) {
			healthIssuesSet.add("Other");	
		}

		// Mood/Cognitive

		if (healthHistoryRecordDTO.getMdAnxiety()) {
			healthIssuesSet.add("Anxiety");
		}
		if (healthHistoryRecordDTO.getMdBipolar()) {
			healthIssuesSet.add("Bipolar");
		}
		if (healthHistoryRecordDTO.getMdDepression()) {
			healthIssuesSet.add("Depression");
		}
		if (healthHistoryRecordDTO.getMdParanoia()) {
			healthIssuesSet.add("Paranoia");
		}
		if (healthHistoryRecordDTO.getMdPTSD()) {
			healthIssuesSet.add("PTSD (Post Traumatic Stress Disorder)");
		}
		if (healthHistoryRecordDTO.getMdSchizophrenia()) {
			healthIssuesSet.add("Schizophrenia");
		}
		if (healthHistoryRecordDTO.getMdOther()) {
			healthIssuesSet.add("Other");
		}

		// Nerve

		if (healthHistoryRecordDTO.getNvEpilepsy()) {
			healthIssuesSet.add("Epilepsy");
		}
		if (healthHistoryRecordDTO.getNvMultipleSclerosis()) {
			healthIssuesSet.add("Multiple Sclerosis");
		}
		if (healthHistoryRecordDTO.getNvNumbness()) {
			healthIssuesSet.add("Numbness");
		}
		if (healthHistoryRecordDTO.getNvParalysis()) {
			healthIssuesSet.add("Paralysis");
		}
		if (healthHistoryRecordDTO.getNvSeizures()) {
			healthIssuesSet.add("Seizures (Not Epilepsy)");
		}
		if (healthHistoryRecordDTO.getNvOther()) {
			healthIssuesSet.add("Other");
		}

		// Nose Bleeds
		if (healthHistoryRecordDTO.getNbOnePerMonth()) {
			healthIssuesSet.add(">1/month");
		}
		if (healthHistoryRecordDTO.getNbOnePerWeek()) {
			healthIssuesSet.add(">1/week");
		}
		if (healthHistoryRecordDTO.getNbOnePerDay()) {
			healthIssuesSet.add(">1/day");
		}

		// Pain

		if (healthHistoryRecordDTO.getPnBack()) {
			healthIssuesSet.add("Back");
		}
		if (healthHistoryRecordDTO.getPnJoint()) {
			healthIssuesSet.add("Joint");
		}
		if (healthHistoryRecordDTO.getPnMuscle()) {
			healthIssuesSet.add("Muscle");
		}
		if (healthHistoryRecordDTO.getPnLeg()) {
			healthIssuesSet.add("Leg pain walking long distances");
		}
		if (healthHistoryRecordDTO.getPnOther()) {
			healthIssuesSet.add("Other");
		}

		// Skin Disorders

		if (healthHistoryRecordDTO.getSkEczema()) {
			healthIssuesSet.add("Eczema");
		}
		if (healthHistoryRecordDTO.getSkPsoriasis()) {
			healthIssuesSet.add("Psoriasis");
		}
		if (healthHistoryRecordDTO.getSkOther()) {
			healthIssuesSet.add("Other");
		}

		// Sleep Disorders
		if (healthHistoryRecordDTO.getSlInsomnia()) {
			healthIssuesSet.add("Insomnia");
		}
		if (healthHistoryRecordDTO.getSlApnea()) {
			healthIssuesSet.add("Sleep Apnea");
		}
		if (healthHistoryRecordDTO.getSlOther()) {
			healthIssuesSet.add("Other");
		}

		// Smoking History

		if (healthHistoryRecordDTO.getSmCurrent()) {
			healthIssuesSet.add("Current");
		}
		if (healthHistoryRecordDTO.getSmOnePackPerDay()) {
			healthIssuesSet.add(">1 pack/day");
		}
		if (healthHistoryRecordDTO.getSmTenYears()) {
			healthIssuesSet.add(">10 Years");
		}
		if (healthHistoryRecordDTO.getSmTwentyYears()) {
			healthIssuesSet.add(">20 Years");
		}

		// STDs

		if (healthHistoryRecordDTO.getStdChlamydia()) {
			healthIssuesSet.add("Chlamydia");
		}
		if (healthHistoryRecordDTO.getStdGonorrhea()) {
			healthIssuesSet.add("Gonorrhea");
		}
		if (healthHistoryRecordDTO.getStdHerpes()) {
			healthIssuesSet.add("Herpes");
		}
		if (healthHistoryRecordDTO.getStdSyphilis()) {
			healthIssuesSet.add("Syphilis");
		}
		if (healthHistoryRecordDTO.getStdOther()) {
			healthIssuesSet.add("Other");
		}

		// Stomach, Bowel
		if (healthHistoryRecordDTO.getStmIBS()) {
			healthIssuesSet.add("Irritable Bowel Syndrome");
		}
		if (healthHistoryRecordDTO.getStmNausea()) {
			healthIssuesSet.add("Nausea");
		}
		if (healthHistoryRecordDTO.getStmPain()) {
			healthIssuesSet.add("Pain");
		}
		if (healthHistoryRecordDTO.getStmSevereIndigestion()) {
			healthIssuesSet.add("Severe Indigestion");
		}
		if (healthHistoryRecordDTO.getStmUlcers()) {
			healthIssuesSet.add("Ulcers");
		}
		if (healthHistoryRecordDTO.getStmOther()) {
			healthIssuesSet.add("Other");
		}

		// Thyroid
		if (healthHistoryRecordDTO.getThGoiter()) {
			healthIssuesSet.add("Goiter");
		}
		if (healthHistoryRecordDTO.getThTumor()) {
			healthIssuesSet.add("Tumor");
		}
		if (healthHistoryRecordDTO.getThOther()) {
			healthIssuesSet.add("Other");
		}

		// Weight

		if (healthHistoryRecordDTO.getWtOverweight()) {
			healthIssuesSet.add("Overweight");
		}
		if (healthHistoryRecordDTO.getWtUnderweight()) {
			healthIssuesSet.add("Underweight");
		}

		healthIssuesSet.addAll(healthIssuesSet);
		totalIssues = healthIssuesSet.size() + healthHistoryRecordDTO.getOtherHealthIssues().size();

		if (totalIssues == 0) {
			response.getValidationErrors().put("healthIssue", "At least one health issue checkbox must be checked or one other health issue added.");
		}

	}
}

